package ch.frankel.blog.lombok.handler;

import java.util.HashMap;
import java.util.Map;

import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;

/**
 * Maps {@link Class} to {@link Type} for primitives.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class PrimitiveTypeParamMapper implements Mapper<Class<?>, Type> {

    /** Map. */
    private final Map<Class<?>, Type> map;

    /**
     * Constructor.
     * 
     * @param symtab
     *            Symbols table
     */
    public PrimitiveTypeParamMapper(Symtab symtab) {

        map = new HashMap<Class<?>, Type>();

        map.put(void.class, symtab.voidType);
        map.put(int.class, symtab.intType);
        map.put(long.class, symtab.longType);
        map.put(byte.class, symtab.byteType);
        map.put(boolean.class, symtab.booleanType);
        map.put(float.class, symtab.floatType);
        map.put(double.class, symtab.doubleType);
        map.put(char.class, symtab.charType);
        map.put(short.class, symtab.shortType);
    }

    /**
     * @see ch.frankel.blog.lombok.handler.Mapper#get(java.lang.Object)
     */
    public Type get(Class<?> clazz) {

        return map.get(clazz);
    }
}
